/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.dependencydownload.path;

import dev.vankka.dependencydownload.dependency.Dependency;
import dev.vankka.dependencydownload.path.CleanupPathProvider;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public class DirectoryDependencyPathProvider
implements CleanupPathProvider {
    private static final String RELOCATED_FILE_PREFIX = "relocated_";
    private final Path cacheDirectory;

    public DirectoryDependencyPathProvider(Path cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    @Override
    @NotNull
    public Path getCleanupPath() {
        return this.cacheDirectory;
    }

    @Override
    @NotNull
    public Path getDependencyPath(@NotNull Dependency dependency, boolean relocated) {
        return this.cacheDirectory.resolve((relocated ? RELOCATED_FILE_PREFIX : "") + dependency.getStoredFileName());
    }
}

